* Title: Adding a Page to a Book
* Slug: new-book-page

================================================================

To add a page to a book, go to <{path}>/pages<{/path}> subfolder of that book and add create a new <{code}>01. My Page Name.md<{/code}> file. Lets examine file naming convention:

* With <{code}>01.<{/code}> you said the ordering position of the page in the book. To move pages in the book, simply rename them so these bits of file name are in order that you like. Page order number is ignored when page is rendered to the user so users will never see them,
* <{code}>My Page Name<{/code}> is the name of your page. If <{code}>title<{/code}> and/or <{code}>slug<{/code}> attributes are not defined in the page content, this value will be used as page title, and for page slug (system will automatically convert it to <{code}>my-page-name<{/code}> format).

Apart from this handy naming convention, there's nothing super special about pages. Their <{code}>.md<{/code}> file is regular help file that has the same <{page name='help-file-anatomy'}>structure<{/page}> as other help files, and you can use Markdown and our tags to <{page name='formatting-guide'}>format the content<{/page}>, just like in any other help document.

Important attributes:

### Title

Page title (optional). If it is omitted, system will use name of the page file (sans order number and file extension) as page title.

### Slug

Page slug (optional). If it is omitted, system will automatically convert page title to slug format (<{term}>My Page Title<{/term}> will become <{term}>my-page-title<{/term}>).

### Answers Common Question

Common question that this page answers (optional). When set, system will pick up this page and display it in the list of Common Questions, on Help's main page. Example:

<{note}>List of common questions is cached! Don't forget to clear cache after you update questions, or their position in the list.<{/note}>

<{code inline=false}>* Answers Common Question: How can I purchase a license?<{/code}>

### Answer Position

Numerical position of the answer in the list of Common Questions (optional). When ommited, system will use 0 and put this answer at the top of the list.

### Show To

List of <{page name="user-groups"}>user groups<{/page}> that this page is visible to. When this attribute is present, page will be displayed only to users that belong to groups listed in it.

### Hide From

List of <{page name="user-groups"}>user groups<{/page}> that this page should be hidden from.